/****************************************************************************
                   Microsoft RPC Version 2.0
           Copyright Microsoft Corp. 1992, 1993, 1994- 1996
                   Discriminated Union Example

    FILE:       unionp.c

    PURPOSE:    Remote procedures that are linked with the server
                side of RPC distributed application

    FUNCTIONS:  UnionParamProc()  - union, discriminant are parameters
                UnionStructProc() - union, discriminant in structure

    COMMENTS:   This distributed application illustrates distriminated
                union.

****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include "dunion.h"    // header file generated by MIDL compiler


void UnionParamProc(DISCRIM_UNION_PARAM_TYPE *up,
                    short                    sDiscrim)
{
    printf("sDiscrim = %d, data = ", sDiscrim);
    switch(sDiscrim) {
    case 0:
        printf("short %d\n", up->sVal);
        break;
    case 1:
        printf("float %f\n", up->fVal);
        break;
    case 2:
        printf("char %c\n", up->chVal);
        break;
    default:
        printf("invalid\n");
        break;
    }
}

void UnionStructProc(DISCRIM_UNION_STRUCT_TYPE *u)
{
    printf("sDiscrim = %d, data = ", u->sDiscrim);
    switch(u->sDiscrim) {
    case 0:
        printf("short %d\n", u->u.sVal);
        break;
    case 1:
        printf("float %f\n", u->u.fVal);
        break;
    case 2:
        printf("char %c\n", u->u.chVal);
        break;
    default:
        printf("invalid\n");
        break;
    }
}

void Shutdown(void)
{
    RPC_STATUS status;

    printf("Calling RpcMgmtStopServerListening\n");
    status = RpcMgmtStopServerListening(NULL);
    printf("RpcMgmtStopServerListening returned: 0x%x\n", status);
    if (status) {
        exit(status);
    }

    printf("Calling RpcServerUnregisterIf\n");
    status = RpcServerUnregisterIf(NULL, NULL, FALSE);
    printf("RpcServerUnregisterIf returned 0x%x\n", status);
    if (status) {
        exit(status);
    }
}

/* end file dunionp.c */
